% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WalleyeRL.R
\docType{data}
\name{WalleyeRL}
\alias{WalleyeRL}
\title{Growth increment data for Red Lakes Walleye.}
\format{
A data frame with 1543 observations on the following 13 variables.
 \describe{
   \item{fish}{A fish identification number. Unique within a year but not across years.} 
   \item{yearcap}{Year the fish was captured.}
   \item{ce}{A factor denoting capture gear (\code{C}=commercial and \code{E}=experimental nets).} 
   \item{agecap}{Age of fish at capture.}
   \item{lencap}{Length of fish at capture.} 
   \item{inc1}{Scale measurement to first annulus.} 
   \item{inc2}{Scale measurement between first and second annulus.} 
   \item{inc3}{Scale measurement between second and third annulus.}
   \item{inc4}{Scale measurement between third and fourth annulus.}
   \item{inc5}{Scale measurement between fourth and fifth annulus.}
   \item{inc6}{Scale measurement between fifth and sixth annulus.}
   \item{inc7}{Scale measurement between sixth and seventh annulus.}
   \item{radcap}{Scale radius at time of capture} 
 }
}
\source{
Cyterski, M.J. and G.R. Spangler. 1996. A tool for age determination. North American Journal of Fisheries Management 16:403-412. \href{https://raw.githubusercontent.com/fishR-Core-Team/FSAdata/main/data-raw/WalleyeRL.csv}{CSV file}
}
\description{
Growth increment data for Red Lakes Walleye (\emph{Sander vitreus}) in one-fish-per-line format.
}
\note{
Data is in one-fish-per-line format.
}
\section{Topic(s)}{

 \itemize{
   \item Growth increment analysis 
   \item Weisberg linear growth model 
 }
}

\examples{
data(WalleyeRL)
str(WalleyeRL)
head(WalleyeRL)

}
\concept{Growth}
\concept{Weisberg LGM}
\keyword{datasets}
