% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsgp.functions.R
\name{nsgpCovMatAsym}
\alias{nsgpCovMatAsym}
\title{Calculate an asymmetric NSGP covariance matrix}
\usage{
nsgpCovMatAsym(
  hp,
  input,
  inputNew,
  nBasis = 5,
  corrModel = corrModel,
  gamma = NULL,
  nu = NULL,
  cyclic = NULL,
  whichTau = NULL
)
}
\arguments{
\item{hp}{Vector of hyperparameters estimated by function nsgpr.}

\item{input}{List of Q input variables (see Details).}

\item{inputNew}{List of Q test set input variables.}

\item{nBasis}{Number of B-spline basis functions in each coordinate direction
along which parameters change.}

\item{corrModel}{Correlation function specification used for g(.). It can be
either "pow.ex" or "matern".}

\item{gamma}{Power parameter used in powered exponential kernel function. It
must be 0<gamma<=2.}

\item{nu}{Smoothness parameter of the Matern class. It must be a positive
value.}

\item{cyclic}{Logical vector of dimension Q which defines which covariates
are cyclic (periodic). For example, if basis functions should be cyclic
only in the first coordinate direction, then cyclic=c(T,F). cyclic must
have the same dimension of whichTau. If cyclic is TRUE for some coordinate
direction, then cyclic B-spline functions will be used and the varying
parameters (and their first two derivatives) will match at the boundaries
of that coordinate direction.}

\item{whichTau}{Logical vector of dimension Q identifying which input
coordinates the parameters are function of. For example, if Q=2 and
parameters change only with respect to the first coordinate, then we set
whichTau=c(T,F).}
}
\value{
An asymmetric covariance matrix
}
\description{
Calculate an asymmetric NSGP covariance matrix
}
\references{
Konzen, E., Shi, J. Q. and Wang, Z. (2020) "Modeling
  Function-Valued Processes with Nonseparable and/or Nonstationary Covariance
  Structure" <arXiv:1903.09981>.
}
