% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{residuals.gw}
\alias{residuals.gw}
\title{Extract and Visualize GWRM Model Residuals}
\usage{
\method{residuals}{gw}(
  object,
  type = "pearson",
  rep = 19,
  envelope = FALSE,
  title = "Simulated Envelope of Residuals",
  trace = FALSE,
  parallel = TRUE,
  ncores = 2,
  ...
)
}
\arguments{
\item{object}{object of class \code{"gw"} holding the fitted model}

\item{type}{type of residuals to be extracted. Default is \code{"pearson"}. \code{"response"} and \code{"deviance"} are also available. Deviance residuals are defined as \eqn{2[ln f(y_i|y_i)-ln f(\widehat{\mu}_i|y_i)]}, so that their sum is the value of the deviance statistic.}

\item{rep}{number of replications for envelope construction. Default is 19, that is the smallest 95 percent band that can be built.}

\item{envelope}{a logical value to specify if the envelope is required.}

\item{title}{a title for the envelope.}

\item{trace}{if \code{TRUE} a sort of information is printed during the running time.}

\item{parallel}{if \code{TRUE} use parallel executation.}

\item{ncores}{is the number of cores that we use if \code{parallel} is \code{TRUE}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
Residuals values and plot
}
\description{
residuals is a method which extracts model residuals from \code{"gw"}, commonly returned by \code{gw} function. Optionally, it produces a normal plot with a simulated envelope of the residuals.
}
\details{
The usual Q-Q plot may show an unsatisfactory pattern of the residuals of a model fitted: then we are led to think that the model is badly specificated. The normal plot with simulated envelope indicates that under the distribution of the response variable the model is OK if only a few points fall off the envelope.
}
\examples{
data(goals)
set.seed(1)
fit0 <- gw(goals ~ position, data = goals[sample(1:nrow(goals), 75), ])
residuals(fit0, type = "pearson", rep = 19, envelope = TRUE, trace = FALSE, ncores = 2)

}
