% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/others.R
\name{log_map}
\alias{log_map}
\title{Logarithm map}
\usage{
log_map(manifold, p1, p2)
}
\arguments{
\item{manifold}{Type of manifold (\code{'euclidean'}, \code{'sphere'},
\code{'hyperbolic'}, or \code{'kendall'}).}

\item{p1}{A vector (or column matrix) representing a point on the manifold.}

\item{p2}{A vector (or column matrix) representing a point on the manifold.}
}
\value{
A vector tangent to \code{p1}.
}
\description{
Performs the logarithm map \eqn{\textrm{Log}_{p_1}(p_2)} on the given
manifold, provided \eqn{p_2} is in the domain of \eqn{\textrm{Log}_{p_1}}.
}
\details{
On the sphere, \eqn{-p_1} is not in the domain of \eqn{\textrm{Log}_{p_1}}.
}
\examples{
log_map('sphere', c(0, 1, 0, 0), c(0, 0, 1, 0))

}
\references{
Fletcher, P. T. (2013). Geodesic regression and the theory of
  least squares on Riemannian manifolds. International Journal of Computer
  Vision, 105, 171-185.

  Cornea, E., Zhu, H., Kim, P. and Ibrahim, J. G. (2017). Regression models
  on Riemannian symmetric spaces. Journal of the Royal Statistical Society:
  Series B, 79, 463-482.

  Calinon, S. (2020). Gaussians on Riemannian manifolds: Applications for
  robot learning and adaptive control. IEEE Robotics & Automation Magazine,
  27, 33-45.

  Shin, H.-Y. and Oh H.-S. (2020). Robust Geodesic Regression.
  <arXiv:2007.04518>
}
\seealso{
\code{\link{exp_map}}, \code{\link{geo_dist}}.
}
\author{
Ha-Young Shin
}
