% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/others.R
\name{loss}
\alias{loss}
\title{Loss}
\usage{
loss(manifold, p, V, x, y, estimator, cutoff = NULL)
}
\arguments{
\item{manifold}{Type of manifold (\code{'euclidean'}, \code{'sphere'},
\code{'hyperbolic'}, or \code{'kendall'}).}

\item{p}{A vector (or column matrix) on the manifold.}

\item{V}{A matrix (or vector) where each column is a vector in the tangent
space at \code{p}.}

\item{x}{A matrix or data frame of independent variables; for matrices and
data frames, the rows and columns represent the subjects and independent
variables, respectively.}

\item{y}{A matrix or data frame (or vector) whose columns represent points on
the manifold.}

\item{estimator}{M-type estimator (\code{'l2'}, \code{'l1'}, \code{'huber'},
or \code{'tukey'}).}

\item{cutoff}{Cutoff parameter for the \code{'huber'} and \code{'tukey'}
estimators; should be \code{NULL} for the \code{'l2'} or \code{'l1'}
estimators.}
}
\value{
Loss.
}
\description{
Loss for a given \code{p} and \code{V}.
}
\examples{
y <- matrix(0L, nrow = 3, ncol = 64)
for (i in 1:64) {
  y[, i] <- exp_map('hyperbolic', c(1, 0, 0), c(0, runif(1), runif(1)))
}
intrinsic_mean <- intrinsic_location('hyperbolic', y, 'l2')
loss('hyperbolic', intrinsic_mean, numeric(3), numeric(64), y, 'l2')

}
\author{
Ha-Young Shin
}
