% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal.R
\name{rnormtangents}
\alias{rnormtangents}
\title{Random generation of tangent vectors from the Riemannian normal distribution}
\usage{
rnormtangents(manifold, N, n, sigma_sq)
}
\arguments{
\item{manifold}{Type of manifold (\code{'sphere'} or \code{'hyperbolic'}).}

\item{N}{Number of points to generate.}

\item{n}{Dimension of the manifold.}

\item{sigma_sq}{A scale parameter.}
}
\value{
An \code{(n+1)}-by-\code{N} matrix where each column represents a random
  tangent vector at \code{(1, 0, ..., 0)}.
}
\description{
Random generation of tangent vectors from the Riemannian normal distribution
on the \code{n}-dimensional sphere or hyperbolic space at mean \code{(1, 0,
..., 0)}, a vector of length \code{n+1}.
}
\details{
Tangent vectors are of the form \eqn{\mathrm{Log}(\mu, y)} in the tangent
space at the Fr\'echet mean \eqn{\mu} = \code{(1, 0, ..., 0)}, which is
isomorphic to \code{n}-dimensional Euclidean space, where \eqn{y} has a
Riemannian normal distribution. The first element of these vectors
will always be 0 at this \eqn{\mu}. These vectors can be
transported to any other \eqn{\mu} on the manifold.
}
\examples{

sims <- rnormtangents('hyperbolic', N = 4, n = 2, sigma_sq = 1)

}
\references{
Fletcher, P. T. (2013). Geodesic regression and the theory of
  least squares on Riemannian manifolds. International Journal of Computer
  Vision, 105, 171-185.

  Fletcher, T. (2020). Statistics on manifolds. In \emph{Riemannian Geometric
  Statistics in Medical Image Analysis}. 39--74. Academic Press.

  Shin, H.-Y. and Oh H.-S. (2020). Robust Geodesic Regression.
  <arXiv:2007.04518>
}
\author{
Ha-Young Shin
}
