% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_int_beta.R
\name{gen_int_beta}
\alias{gen_int_beta}
\title{Hierarchical Heterogeneity Regression Analysis.}
\usage{
gen_int_beta(n, p, q, whole.data, subgroup=c(2,4),
                    ridge = FALSE, gr.init=10, lambda.min=0.0001)
}
\arguments{
\item{n}{The sample size.}

\item{p}{The dimension of type 2 features.}

\item{q}{The dimension of type 1 features.}

\item{whole.data}{The input data analyzed (a list including the response and design matrix).}

\item{subgroup}{When using fmrs to generate initial value, the initial value parameter of fmrs is given. Randomly divide this number of groups into several groups.}

\item{ridge}{The logical variable, whether or not to yield initial values using ridge regression.}

\item{gr.init}{The subgroup number of initial values using ridge regression.}

\item{lambda.min}{The tuning parameter using ridge regression, the default is 0.0001.}
}
\value{
A result list.
}
\description{
The main function for Transfer learning for tensor graphical models.
}
\examples{
\donttest{
library(HhP)
library(Matrix)
library(MASS)
library(fmrs)
data(example.data.reg)
n = example.data.reg$n
q = example.data.reg$q
p = example.data.reg$p

beta.init.list  =  gen_int_beta(n, p, q, example.data.reg)
beta.init  =  beta.init.list$beta.init
lambda  =  genelambda.obo()
result  =  HhP.reg(lambda, example.data.reg, n, q, p, beta.init)
index.list  =  evaluation.sum(n,q,p, result$admmres, result$abic.n,
               result$admmres2, example.data.reg$Beta0, result$bic.var)
index.list$err.s
}


}
\references{
Mingyang Ren, Qingzhao Zhang, Sanguo Zhang, Tingyan Zhong, Jian Huang, Shuangge Ma. 2022. Hierarchical Cancer Heterogeneity Analysis Based On Histopathological Imaging Features. Biometrics, <DOI: 10.1111/biom.13544>.
}
\author{
Mingyang Ren, Qingzhao Zhang, Sanguo Zhang, Tingyan Zhong, Jian Huang, Shuangge Ma. Maintainer: Mingyang Ren \href{mailto:renmingyang17@mails.ucas.ac.cn}{renmingyang17@mails.ucas.ac.cn}.
}
