% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{adm2020}
\alias{adm2020}
\title{Admissions and Test Scores 2020 Data}
\format{
A data frame of 1989 rows representing institutions and 39 variables

\describe{
\item{INSTITUTION_ID}{Unique identification number of the institution}
\item{hs_gpa}{Secondary school GPA: a factor with 4 levels: \code{Required}, \code{Recommended}, \code{Neither_required_nor_recommended}, and \code{Considered_but_not_required}}
\item{hs_rank}{Secondary school rank: a factor with 4 levels: \code{Required}, \code{Recommended}, \code{Neither_required_nor_recommended}, and \code{Considered_but_not_required}}
\item{hs_record}{Secondary school record: a factor with 4 levels: \code{Required}, \code{Recommended}, \code{Neither_required_nor_recommended}, and \code{Considered_but_not_required}}
\item{cprep_program}{Completion of college-preparatory program: a factor with 4 levels: \code{Required}, \code{Recommended}, \code{Neither_required_nor_recommended}, and \code{Considered_but_not_required}}
\item{recs}{Recommendations: a factor with 4 levels: \code{Required}, \code{Recommended}, \code{Neither_required_nor_recommended}, and \code{Considered_but_not_required}}
\item{competencies}{Formal demonstration of competencies: a factor with 4 levels: \code{Required}, \code{Recommended}, \code{Neither_required_nor_recommended}, and \code{Considered_but_not_required}}
\item{adm_tscores}{Admission test scores: a factor with 4 levels: \code{Required}, \code{Recommended}, \code{Neither_required_nor_recommended}, and \code{Considered_but_not_required}}
\item{test_eng_FL}{TOEFL (Test of English as a Foreign Language: a factor with 4 levels: \code{Required}, \code{Recommended}, \code{Neither_required_nor_recommended}, and \code{Considered_but_not_required}}
\item{other_test}{Other Test (Wonderlic, WISC-III, etc.: a factor with 4 levels: \code{Required}, \code{Recommended}, \code{Neither_required_nor_recommended}, and \code{Considered_but_not_required}}
\item{APPLCN}{Applicants total}
\item{APPLCNM}{Applicants men}
\item{APPLCNW}{Applicants men}
\item{ADMSSN}{Admissions total}
\item{ADMSSNM}{Admissions men}
\item{ADMSSNW}{Admissions women}
\item{ENRLT}{Enrolled total}
\item{ENRLM}{Enrolled men}
\item{ENRLW}{Enrolled women}
\item{FT_enroll}{Enrolled full time total}
\item{FT_enroll_M}{Enrolled full time men}
\item{FT_enroll_W}{Enrolled full time women}
\item{PT_enroll}{Enrolled part time total}
\item{PT_enroll_M}{Enrolled part time men}
\item{PT_enroll_W}{Enrolled part time women}
\item{SAT_num}{Number of first-time degree/certificate-seeking students submitting SAT scores}
\item{SAT_pct}{Percent of first-time degree/certificate-seeking students submitting SAT scores}
\item{ACT_num}{Number of first-time degree/certificate-seeking students submitting ACT scores}
\item{ACT_pct}{Percent of first-time degree/certificate-seeking students submitting ACT scores}
\item{RW_SAT_25}{SAT Evidence-Based Reading and Writing 25th percentile score}
\item{RW_SAT_75}{SAT Evidence-Based Reading and Writing 75th percentile score}
\item{MTH_SAT_25}{SAT Math 25th percentile score}
\item{MTH_SAT_75}{SAT Math 75th percentile score}
\item{ACT_25}{ACT Composite 25th percentile score}
\item{ACT_75}{ACT Composite 75th percentile score}
\item{eng_ACT_25}{ACT English 25th percentile score}
\item{eng_ACT_75}{ACT English 75th percentile score}
\item{MTH_ACT_25}{ACT Math 25th percentile score}
\item{MTH_ACT_75}{ACT Math 75th percentile score}
}
}
\source{
Download from Integrated Postsecondary Education Data System,
\url{https://nces.ed.gov/ipeds/datacenter/data/ADM2020.zip}.
}
\usage{
adm2020
}
\description{
This file contains information about the undergraduate selection process for entering first-time, degree/certificate-seeking students. This includes information about admission considerations,  applicants, applicants that were admitted, and admitted students who enrolled. SAT and ACT test scores are included for institutions, that require test scores for admission. These data are applicable for institutions that do not have an open admissions policy for entering first-time students. Beginning with 2016, writing scores for both SAT and ACT are no longer collected. The possible values for the admission consideration variables have changed from data prior to 2016.
}
\details{
Provisional release data have undergone all NCES data quality control procedures. Data are imputed for nonresponding institutions.
}
\keyword{datasets}
