% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makl_train.R
\name{makl_train}
\alias{makl_train}
\title{Train a Multiple Approximate Kernel Learning (MAKL) Model}
\usage{
makl_train(
  X,
  y,
  D = 100,
  sigma_N = 1000,
  CV = 1,
  lambda_set = c(0.9, 0.8, 0.7, 0.6),
  membership
)
}
\arguments{
\item{X}{training dataset, matrix of size N x d.}

\item{y}{response vector of length N, containing only -1 and 1.}

\item{D}{numeric value related to the number of random features to be used for approximation.}

\item{sigma_N}{numeric value preferably smaller than N, used to calculate sigma to create random features.}

\item{CV}{integer value between 0 and N. If CV is equal to 0 or 1, no cross validation is performed. If CV is greater than or equal to 2, CV is assigned as fold count in the cross validation.}

\item{lambda_set}{a continuous number between 0 and 1, used for regularization.}

\item{membership}{a list of length of number of groups, containing feature memberships to each group.}
}
\value{
a list containing the MAKL model and related parameters to be used in makl_test().
}
\description{
Train a MAKL model to be used as an input to makl_test().
}
