% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MFOs.R
\name{MFOs}
\alias{MFOs}
\title{Maximal Fat Oxidation calculation of multiple databases}
\usage{
MFOs(
  from = c("folder", "files"),
  path,
  db_basal_name,
  db_MFO_name,
  db_graded_name,
  step_time,
  cv_var,
  author,
  VO2max = NULL,
  remove_rows = NULL,
  col_name_VO2 = "VO2",
  col_name_VCO2 = "VCO2",
  col_name_RER = "RER",
  col_name_HR = "HR",
  save_plot = TRUE,
  save_result = TRUE
)
}
\arguments{
\item{from}{select or folder (basal, MFO and graded databases of the same participant are store in
different files but in the same folder) or files (basal, MFO and graded databases of the
same participant are store in one file but in different sheets)}

\item{path}{path to the folder with the databases}

\item{db_basal_name}{name given to the basal database, eg: basal_df}

\item{db_MFO_name}{name given to the MFO database, eg: MFO_df}

\item{db_graded_name}{name given to the graded database, eg: VO2max_df}

\item{step_time}{how often the data was collected (in seconds).}

\item{cv_var}{variable to estimate coefficient of variation. Can be: VO2, VCO2 or RER.}

\item{author}{author to estimate MFO. Can be: Frayn or Jeukendrup.}

\item{VO2max}{VO2max can be passed directly using this argument instead of use db_graded argument. Default set to NULL.}

\item{remove_rows}{An integer (or a vector of integers) representing the position of the rows to delete}

\item{col_name_VO2}{name given to the variable VO2 in the databases. Must be the same for all databases. Default set to "VO2"}

\item{col_name_VCO2}{name given to the variable VCO2 in the databases. Must be the same for all databases. Default set to "VCO2"}

\item{col_name_RER}{name given to the variable RER in the databases. Must be the same for all databases. Default set to "RER"}

\item{col_name_HR}{name given to the variable HR in the databases. Must be the same for all databases. Default set to "HR"}

\item{save_plot}{to save the plot or not. Default set to True.}

\item{save_result}{to save the results in a .xlsx file or not. Default set to True.}
}
\value{
{This function creates an .xlsx file in the working directory with the
following variables:
\itemize{
\item MFO_db: database used to create the MFO plot.
\item MFO_plot: ggplot object with the MFO plot.
\item MFO: Maximal fat oxidation.
\item FAT_MAX: Intensity that elicits MFO.
\item x_CHO: carbohydrates in basal metabolism.
\item x_FAT: fat in basal metabolism.
\item x_Kcal: Kcal in basal metabolism.
}}
}
\description{
Maximal Fat Oxidation calculation of multiple databases
}
\examples{

\dontrun{
# Get old working directory
oldwd <- getwd()

# Set temporary directory
setwd(tempdir())

# Create path to store databases
dir.create(paste(getwd(),"/MFO_databases", sep = ""))
# Get path to databases
path <- paste(getwd(),"/MFO_databases", sep = "")

# MFOs function
# "path" is the path to the databases
MFOs <- function(from = "folder",
                 path = path,
                 db_basal_name = "basal_df",
                 db_MFO_name = "MFO_df",
                 db_graded_name = "graded_df",
                 step_time = 20,
                 cv_var = "RER",
                 author = "Frayn",
                 VO2max = NULL,
                 remove_rows = NULL,
                 col_name_VO2 = "VO2",
                 col_name_VCO2 = "VCO2",
                 col_name_RER = "RER",
                 col_name_HR = "HR",
                 save_plot = TRUE,
                 save_result = TRUE)

# set user working directory
setwd(oldwd)
}

}
