% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_part1.r
\name{model_configuration}
\alias{model_configuration}
\title{model_configuration function}
\usage{
model_configuration(data_train, data_valid, mv, model = "lm")
}
\arguments{
\item{data_train}{This includes the dataframe of the training dataset in a matrix format}

\item{data_valid}{This includes the dataframe of the validation dataset in a matrix format}

\item{mv}{The total number of columns in data_train/data_valid}

\item{model}{This is the type of model (e.g. lm (default) or glm)}
}
\value{
This function will generate all possible model outcomes for validation and test dataset
}
\description{
This function generates predicted values for the validation dataset by applying
optimal weights to features, which were estimated in the training dataset for each
model configuration. The total number of model configurations is determined by
summing the combinations for each possible number of features,
ranging from 1 to 'n' (C(n, k)), where 'n choose k' (C(n, k)) represents the binomial
coefficient. Here, 'n' denotes the total number of features, and 'k' indicates
the number of features included in each model. For example, with n=7,
the total number of model configurations is 127.
}
\examples{
\donttest{
data_train <- data_train
data_valid  <- data_valid
mv=8
out=model_configuration(data_train,data_valid,mv,model = "lm")
#This process will produce predicted values for the validation datasets,
#corresponding to each model configuration trained on the training dataset.
#The outcome of this function will yield variables named 'predict_validation'
#and 'total_model_configurations.
#To print the outcomes run out$predict_validation and out$total_model_configurations.
#For details (see https://github.com/mommy003/MSML). 
}
}
\keyword{All}
\keyword{combinations}
\keyword{model}
\keyword{possible}
