% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RotatabilityQ.R
\name{RotatabilityQ}
\alias{RotatabilityQ}
\title{Measure of rotatability Q based on a second order model}
\usage{
RotatabilityQ(design)
}
\arguments{
\item{design}{Second order design matrix without intercept}
}
\value{
Rotatability measure Q
}
\description{
Calculates the measure of rotatability (measure Q, 0 <= Q <= 1) given by Draper and Pukelsheim(1990) for given design based on a second order model.
}
\examples{
\dontrun{
library(MixedLevelRSDs)
RotatabilityQ(design)
}
}
\references{
1)	Norman R. Draper and Friedrich Pukelsheim(1990), <doi: 10.1080/00401706.1990.10484635>. "Another look at rotatability".

2)	M. Hemavathi, Shashi Shekhar, Eldho Varghese, Seema Jaggi, Bikas Sinha & Nripes Kumar Mandal (2022)<doi: 10.1080/03610926.2021.1944213>." Theoretical developments in response surface designs:    an informative review and further thoughts.".
}
