% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/team.R
\name{getTeamHistory}
\alias{getTeamHistory}
\title{Franchise History Data}
\usage{
getTeamHistory(team_code)
}
\arguments{
\item{team_code}{Team code consisting of 3 characters to fetch information for}
}
\value{
This function returns \code{data.frame} including columns:
\itemize{
 \item Season
 \item Lg
 \item Team
 \item W
 \item L
 \item W/L%
 \item Finish
 \item SRS
 \item Pace
 \item RelativePage
 \item ORtg
 \item RelativeORtg
 \item DRtg
 \item RelativeDRtg
 \item Playoffs
 \item Coaches
 \item TopWinShare
}
}
\description{
Franchise's season data
}
\examples{
\dontrun{
  BostonCeltics <- getTeamHistory(team_code = "bos")
  head(BostonCeltics)
}

}
\seealso{
\url{https://www.basketball-reference.com/teams/}
}
\author{
Koki Ando <koki.25.ando@gmail.com>
}
