% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasonal_trend.R
\name{seasonal_trend}
\alias{seasonal_trend}
\title{Generation of a seasonal trend}
\usage{
seasonal_trend(j, lambda, n_wave, n_total)
}
\arguments{
\item{j}{Time points for which the trend should be generated.}

\item{lambda}{Strength of time trend.}

\item{n_wave}{How many cycles (waves) should the time trend have (\eqn{\psi}).}

\item{n_total}{Total sample size in the trial.}
}
\value{
Time trend for time points j.
}
\description{
This function generates a time trend for given time points in the trial according to a periodic function.
}
\details{
The time trend is generated according to the function \eqn{f(j) = \lambda \cdot \mathrm{sin} \big( \psi \cdot 2\pi \cdot \frac{j-1}{N-1} \big)}, where \eqn{N} is the total sample size  (parameter \code{n_total}) and the parameter \eqn{\psi} corresponds to the input parameter \code{n_wave}.
}
\author{
Marta Bofill Roig, Pavla Krotka
}
