% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NonProbEst.R
\name{generic_jackknife_variance}
\alias{generic_jackknife_variance}
\title{Calculates Jackknife variance with reweighting for an arbitrary estimator}
\usage{
generic_jackknife_variance(sample, estimator, N = NULL)
}
\arguments{
\item{sample}{Data frame containing the non-probabilistic sample.}

\item{estimator}{Function that, given a sample as a parameter, returns an estimation.}

\item{N}{Integer indicating the population size. Optional.}
}
\value{
The resulting variance.
}
\description{
Calculates the variance of a given estimator by Leave-One-Out Jackknife (Quenouille, 1956) with reweighting in each iteration.
}
\details{
The estimation of the variance requires a recalculation of the estimates in each iteration which might involve weighting adjustments, leading to an increase in computation time. It is expected that the estimated variance captures the weighting adjustments' variability and the estimator's variability.
}
\examples{
\donttest{
covariates = c("education_primaria", "education_secundaria",
   "age", "sex", "language")
if (is.numeric(sampleNP$vote_gen))
   sampleNP$vote_gen = factor(sampleNP$vote_gen, c(0, 1), c('F', 'T'))
vote_gen_estimator = function(sample) {
   model_based(sample, population, covariates,
      "vote_gen", positive_label = 'T', algorithm = 'glmnet')
}
generic_jackknife_variance(sampleNP, vote_gen_estimator)
}
}
\references{
Quenouille, M. H. (1956). \emph{Notes on bias in estimation.} Biometrika, 43(3/4), 353-360.
}
