% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Reference.R
\name{Reference}
\alias{Reference}
\title{Calculate the SPI and SPEI Using a Reference Data Source}
\usage{
Reference(ref, distr = "GEV", PEMethod = "HS", TS = 4L)
}
\arguments{
\item{ref}{A data frame with the variables required for calculating the \acronym{SDI}s.
See \code{refHS} or \code{refPM} as examples.}

\item{distr}{A character variable (\dQuote{GEV} or \dQuote{GLO}) defining which
distribution is used to calculate the \acronym{SPEI}. Default is
\dQuote{GEV}.}

\item{PEMethod}{A character variable (\dQuote{HS} or \dQuote{PM}) defining the potential
evapotranspiration method.  Default is \dQuote{HS}.}

\item{TS}{Time scale on the \dQuote{quart.month} basis (whole values between 1 and
96).  Default is 4.}
}
\value{
A data frame with five columns
\itemize{
  \item rain,
  \item potential evapotranspiration,
  \item difference between rainfall and potential evapotranspiration,
  \item \acronym{SPI} calculated at the time scale selected by the user, and
  \item \acronym{SPIE} calculated at the time scale selected by the user
  }
}
\description{
Calculates the Standardised Precipitation Index (\acronym{SPI}) and
  Standardised Precipitation-Evapotranspiration Index (\acronym{SPEI}) using
  a reference data source.
}
\examples{

Reference(ref = refHS, distr = "GEV", PEMethod = "HS", TS = 4)

}
