% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcDT.R
\name{sortByRowIndexDT}
\alias{sortByRowIndexDT}
\title{Order the rows of a data.table object by index}
\usage{
sortByRowIndexDT(inputDT, rowIndices)
}
\arguments{
\item{inputDT}{data.table object containing the data of interest. This is an obligatory argument, without default value.}

\item{rowIndices}{Integer vector that contains the row indices according to which the 'inputDT' object should be ordered. This is an obligatory argument, without default value.}
}
\value{
The 'inputDT' data.table object, ordered according to the 'rowIndices' argument. This function assumes that the length of the 'rowIndices' argument is correspond to the number of rows of the 'inputDT' argument. If the length of the 'rowIndices' argument is smaller than the number of rows of the 'inputDT' argument, the values of the 'rowIndices' argument are recycled until the as many indices as number of rows of the 'inputDT' argument is obtained.
}
\description{
Order the rows of a data.table object by index
}
\examples{
library(data.table)
inputDT <- as.data.table(data.frame(x = 10:1, y = LETTERS[1:10]))
asFactorDT(inputDT, c('y'))
inputDT
sortByRowIndexDT(inputDT, 10:1)
inputDT
}
