/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.ARPHandlers;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.arp.JenaReader;
import com.hp.hpl.jena.rdf.arp.NamespaceHandler;
import com.hp.hpl.jena.rdf.arp.StatementHandler;
import com.hp.hpl.jena.rdf.arp.impl.ARPSaxErrorHandler;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import java.util.Arrays;

final class JenaHandler
extends ARPSaxErrorHandler
implements StatementHandler,
NamespaceHandler {
    private static final int BULK_UPDATE_SIZE = 1000;
    private final BulkUpdateHandler bulk;
    private final Model model;
    final Triple[] triples;
    int ix = 0;

    public JenaHandler(Model m, RDFErrorHandler e) {
        this(m.getGraph(), m, e);
    }

    JenaHandler(Graph g, RDFErrorHandler e) {
        this(g, null, e);
    }

    public JenaHandler(Graph g, Model m, RDFErrorHandler e) {
        this(g.getBulkUpdateHandler(), m, e);
    }

    private JenaHandler(BulkUpdateHandler bulk, Model model, RDFErrorHandler errorHandler) {
        super(errorHandler);
        this.bulk = bulk;
        this.model = model;
        this.triples = new Triple[1000];
    }

    public void useWith(ARPHandlers h) {
        h.setStatementHandler(this);
        h.setErrorHandler(this);
        h.setNamespaceHandler(this);
    }

    public void statement(AResource subj, AResource pred, AResource obj) {
        try {
            this.triples[this.ix++] = JenaReader.convert(subj, pred, obj);
        }
        catch (JenaException e) {
            this.errorHandler.error(e);
        }
        if (this.ix == 1000) {
            this.bulkUpdate();
        }
    }

    public void statement(AResource subj, AResource pred, ALiteral lit) {
        try {
            this.triples[this.ix++] = JenaReader.convert(subj, pred, lit);
        }
        catch (JenaException e) {
            this.errorHandler.error(e);
        }
        if (this.ix == 1000) {
            this.bulkUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bulkUpdate() {
        try {
            if (this.ix == 1000) {
                this.bulk.add(this.triples);
            } else {
                this.bulk.add(Arrays.asList(this.triples).subList(0, this.ix));
            }
        }
        catch (JenaException e) {
            this.errorHandler.error(e);
        }
        finally {
            this.ix = 0;
        }
    }

    public void startPrefixMapping(String prefix, String uri) {
        if (this.model != null && PrefixMappingImpl.isNiceURI(uri)) {
            this.model.setNsPrefix(prefix, uri);
        }
    }

    public void endPrefixMapping(String prefix) {
    }
}

