% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RadVizGadget.R
\name{RadViz}
\alias{RadViz}
\title{RadViz Gadget}
\usage{
RadViz(df, color = NULL)
}
\arguments{
\item{df}{A dataframe with the data to explore. It should contain only numeric columns (with the exception of the label column).}

\item{color}{column where labels from the data are extracted.}
}
\value{
A list location of the anchors, coordinates of the projected samples and a logical vector with the selected samples
}
\description{
Creates a RShiny Gadget for RadViz
}
\details{
RadViz's  goal is to generate a configuration which reveals the underlying nature of the data for cluster analysis, 
outlier detection, and exploratory data analysis, e.g., by investigating the effect of specific dimensions on the separation of the data.  
Each dimension is assigned to a point known as dimensional anchors across a unit-circle.  Each sample is projected according to the 
relative attraction to each of the anchors. 

It is defined defined for multidimensional numerical data sets \eqn{X=\{\mathbf{p}_1,\ldots, \mathbf{p}_N\},} 
for N data points \eqn{\mathbf{x}_i \in \mathbf{R}^{d}} of dimensionality d. Let \eqn{A =\{ \mathbf{a}_{1}, \dots, \mathbf{a}_{d}  \} ,} 
be a set of (typically 2D) anchors, each corresponding to one of the d dimensions.
The projection \eqn{ \mathbf{p}_i' \in \mathbf{R}^{2},} of a multidimensional point \eqn{ \mathbf{p}_i = (p_{i1},\ldots,p_{id}) \in \mathbf{R}^{d}, }in SC is then defined as:
\deqn{ \mathbf{x}_i' = \frac{ \sum_{j=1}^{d} \mathbf{a}_{j} g_j( \mathbf{p}_i)}{\sum_{j=1}^{d} \mathbf{a}_{j}  },} with
\deqn{ g_j(\mathbf{p}_i) = \frac{p_{ij} - min_j}{max_j - min_j} ,} and \eqn{(min_j,max_j),}denoting the value range of dimension j. 
The dimensional anchors can be moved either interactively or algorithmically to reveal different meaningful patterns in the dataset.
}
\examples{
if (interactive()) {
 library(RadialVisGadgets)
 library(datasets)
 data(iris)
 RadViz(iris, "Species")
}

}
\references{
Sharko, J., Grinstein, G., & Marx, K. A. (2008). Vectorized radviz and its application to multiple cluster datasets. IEEE transactions on Visualization and Computer Graphics, 14(6), 1444-1427.
}
