% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankL2R.R
\name{rankL2R}
\alias{rankL2R}
\title{Rank responses under the Bayesian framework according to
the loss function in Method 3 of Wang and Huang (2004).}
\usage{
rankL2R(data, response.number, prior.parameter, e)
}
\arguments{
\item{data}{A m by n matrix \eqn{d_{ij}}, where \eqn{d_{ij}} = 0 or 1.
If the ith respondent selects the jth
response, then \eqn{d_{ij}} = 1, otherwise \eqn{d_{ij}} = 0.}

\item{response.number}{The number of the responses.}

\item{prior.parameter}{The parameter vector of the Dirichlet prior distribution,
where the vector dimension is 2^{response.number}.}

\item{e}{A cut point used in the loss function which depends on the economic costs.}
}
\value{
The rankL2R returns the estimated probabilities of the responses
being selected in the first line and the ranks of the responses in the second line.
}
\description{
Rank responses of a single response question or
a multiple response question under the Bayesian framework according to the
loss function in Method 3 of Wang and Huang (2004).
}
\examples{
set.seed(12345)
# This is an example to rank k responses in a multiple response question
# when the number of respondents is 1000 and the value e is 0.15.
# In this example, we do not use a real data, but generate data in the first six lines.
k <- 3
data <- matrix(NA, nrow = 1000, ncol = k)
for(i in 1:k){
  p <- runif(1)
  data[, i] <- sample(c(0, 1), 1000, p = c(p, 1-p), replace = TRUE)
}
## or upload the true data
response.number <- 3
prior.parameter <- c(5, 98, 63, 7, 42, 7, 7, 7)
e <- 0.15
rankL2R(data, response.number, prior.parameter, e)

}
\references{
Wang, H. and Huang, W. H. (2014). Bayesian Ranking Responses in Multiple Response Questions.
            Journal of the Royal Statistical Society: Series A (Statistics in Society), 177, 191-208.
}
\seealso{
\code{\link{rankLN}}, \code{\link{rank.wald}}, \code{\link{rank.gs}}
}
\author{
Hsiuying Wang \email{wang@stat.nycu.edu.tw}
, Yu-Chun Lin \email{restart79610@hotmail.com}
}
