% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rprofet.R
\name{BinProfet}
\alias{BinProfet}
\title{Coarse Binning Variable(s)}
\usage{
BinProfet(
  data,
  id,
  target,
  varcol,
  min.cat = 4,
  num.bins = 10,
  min.pts.bin = 25,
  bracket = "left",
  special.values = NULL,
  sort_id = FALSE
)
}
\arguments{
\item{data}{Dataframe of that contains ID, binary target and variables to be binned.}

\item{id}{ID variable. See 'Details'.}

\item{target}{The binary target/response variable for WOE. See 'Details'.}

\item{varcol}{Vector of variables to be binned.}

\item{min.cat}{Minimum number of bins.}

\item{num.bins}{Target number of bins. Overridden by the number of levels if varcol is factor.}

\item{min.pts.bin}{Minimum number of observations in a bin.}

\item{bracket}{Indicating if the intervals should be closed on the right or left. Options include left and right.}

\item{special.values}{A vector of values that should have their own bin. See 'Details'.}

\item{sort_id}{Logical. The default is FALSE which does not sort the data by ID column. If TRUE, then data is sorted increasingly by ID column.}
}
\value{
A dataframe containing the ID, target, and binned variable(s) with corresponding binned values.
}
\description{
Function that bins selected variable(s) and returns a dataframe with binned values. Uses greedy binning algorithm to perform coarse binning of selected variable(s).
}
\examples{
mydata <- ISLR::Default
head(mydata)
mydata$ID <- seq(1:nrow(mydata)) ## make an ID variable
mydata$default <- ifelse(mydata$default=="Yes", 1, 0) ## target coded with 1, 0

## bin balance and income
binned1 <- BinProfet(mydata, id="ID", target="default",
                        varcol = c("balance",  "income"), num.bins = 5)
head(binned1)

## bin categorical variable-------------------
binned2 <- BinProfet(mydata, id="ID", target="default",
                        varcol = "student", num.bins = 5)
head(binned2)
summary(binned2$student_Bins) ## num.bins overriden
}
