% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgp_cv.R
\name{sgp.cv}
\alias{sgp.cv}
\title{Cross-validation for sparse group penalties}
\usage{
sgp.cv(
  X,
  y,
  group = 1:ncol(X),
  Z = NULL,
  ...,
  nfolds = 10,
  seed,
  fold,
  type,
  returnY = FALSE,
  print.trace = FALSE
)
}
\arguments{
\item{X}{The design matrix without intercept with the variables to be selected.}

\item{y}{The response vector.}

\item{group}{A vector indicating the group membership of each variable in X.}

\item{Z}{The design matrix of the variables to be included in the model without penalization.}

\item{\dots}{Other parameters of underlying basic functions.}

\item{nfolds}{The number of folds for cross-validation.}

\item{seed}{A seed provided by the user for the random number generator.}

\item{fold}{A vector of folds specified by the user (default is a random assignment).}

\item{type}{A string indicating the type of regression model (linear or binomial).}

\item{returnY}{A Boolean value indicating whether the fitted values should be returned.}

\item{print.trace}{A Boolean value that specifies whether the beginning of a fold should be printed.}
}
\value{
A list containing:
\describe{
\item{cve}{The average cross-validation error for each value of lambda.}
\item{cvse}{The estimated standard error for each value of cve.}
\item{lambdas}{The sequence of lambda values.}
\item{fit}{The sparse group penalty model fitted to the entire data.}
\item{fold}{The fold assignments for each observation for the cross-validation procedure.}
\item{min}{The index of lambda corresponding to the minimum cross-validation error.}
\item{lambda.min}{The value of lambda with the minimum cross-validation error.}
\item{null.dev}{The deviance for the empty model.}
\item{pe}{The cross-validation prediction error for each value of lambda (for binomial only).}
\item{pred}{The fitted values from the cross-validation folds.}
}
}
\description{
A function that performs k-fold cross-validation for sparse group penalties for a lambda sequence.
}
\examples{
\donttest{
# Generate data
 n <- 100
 p <- 200
 nr <- 10
 g <- ceiling(1:p / nr)
 X <- matrix(rnorm(n * p), n, p)
 b <- c(-3:3)
 y_lin <- X[, 1:length(b)] \%*\% b + 5 * rnorm(n)
 y_log <- rbinom(n, 1, exp(y_lin) / (1 + exp(y_lin)))

# Linear regression
 lin_fit <- sgp.cv(X, y_lin, g, type = "linear", penalty = "sgl")
 plot(lin_fit)
 predict(lin_fit, extract = "vars")
 lin_fit <- sgp.cv(X, y_lin, g, type = "linear", penalty = "sgs")
 plot(lin_fit)
 predict(lin_fit, extract = "vars")
 lin_fit <- sgp.cv(X, y_lin, g, type = "linear", penalty = "sgm")
 plot(lin_fit)
 predict(lin_fit, extract = "vars")
 lin_fit <- sgp.cv(X, y_lin, g, type = "linear", penalty = "sge")
 plot(lin_fit)
 predict(lin_fit, extract = "vars")

# Logistic regression
 log_fit <- sgp.cv(X, y_log, g, type = "logit", penalty = "sgl")
 plot(log_fit)
 predict(log_fit, extract = "vars")
 log_fit <- sgp.cv(X, y_log, g, type = "logit", penalty = "sgs")
 plot(log_fit)
 predict(log_fit, extract = "vars")
 log_fit <- sgp.cv(X, y_log, g, type = "logit", penalty = "sgm")
 plot(log_fit)
 predict(log_fit, extract = "vars")
 log_fit <- sgp.cv(X, y_log, g, type = "logit", penalty = "sge")
 plot(log_fit)
 predict(log_fit, extract = "vars")
}

}
