% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cutoff2polygon.R
\name{cutoff2polygon}
\alias{cutoff2polygon}
\title{Create (treated) polygon from line}
\usage{
cutoff2polygon(data, cutoff, orientation = NA, endpoints = c(0, 0))
}
\arguments{
\item{data}{study dataset to determine the bounding box (so that all observations are covered by the new polygons) in sf format}

\item{cutoff}{sf object of the (placebo) cut-off}

\item{orientation}{in which side of the bounding box does each of the extensions of the cutoff go into? First element refers to endpoint of border with smaller x-coordinate ("westernmost") (takes two of "north", "east", "south", "west" in a vector, e.g. \code{c("west", "north")})}

\item{endpoints}{at what position on the edge should each polygon end? (vector with two numbers between 0 and 1, where 0.5 e.g. means right in the middle of the respective edge)}
}
\value{
a polygon as an sf object
}
\description{
Creates an approximation of a "treated/untreated polygon" to assign the status again to each observation after the border has been shifted.
The function extends both ends of the provided cutoff to the edge of the (imaginary) bounding box of the provided data (this ensures all observations will be included).
Key is that you provide a 2-tuple that indicates in which side of the bounding box each end should go (1st element is the one with lower x-coordinate, i.e. leftern most). Always check the output manually by plotting the polygon (e.g. with \code{tm_shape(your.polygon) + tm_polygons()}).
If the output polygon looks odd, a first check should be to just switch the elements from the orientation vector around! See \code{vignette(shifting_borders)} for details and illustrative examples.
}
\examples{
points_samp.sf <- sf::st_sample(polygon_full, 100) # create points
# make it an sf object bc st_sample only created the geometry list-column (sfc):
points_samp.sf <- sf::st_sf(points_samp.sf)
# add a unique ID to each observation:
points_samp.sf$id <- 1:nrow(points_samp.sf)
cutoff2polygon(data = points_samp.sf, cutoff = cut_off,
orientation = c("west", "west"), endpoints = c(.8, .2))
}
