% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tree.R
\name{plot_tree}
\alias{plot_tree}
\title{Tree Plot: Tree Structure, Subgroup-specific treatment estimates}
\usage{
plot_tree(
  object,
  prob.thres = ">0",
  plots = "outcome",
  nudge_out = 0.1,
  width_out = 0.5,
  nudge_dens = ifelse(plots == "both", 0.3, 0.1),
  width_dens = 0.5,
  ...
)
}
\arguments{
\item{object}{PRISM or submod_train object}

\item{prob.thres}{Probability threshold, ex: P(Mean(A=1 vs A=0)>c. Default=NULL, 
which defaults to using ">0", unless param="cox", which  "P(HR(A=1 vs A=0))<1". 
If a density plot is included, setting prob.thres=">c" will use green colors 
for values above c, and red colors for values below c. If tree.thres="<c", the 
reverse color scheme is used.}

\item{plots}{Type of plots to include in each node of the "tree" plot. Default="outcome". 
For non-survival data, if the fitted PRISM object (x) does not include patient-level 
estimates (ple="None"), or if param="lm", this will plot the observed outcomes (Y) by the 
treatment assignment (A). If the fitted PRISM object includes patient-level estimates 
(ex: ple="ranger"), this includes box-plots of the model-based (if param="ple") or double-robust
based (if param="dr") counter-factual estimates of E(Y|X,A=a) for continuous outcomes or 
Prob(Y=1|X,A=a) for binary outcomes (truncated to 0,1). For survival data, Kaplan-Meier 
based survival estimates are plotted by treatment group. For "density", the estimated 
probability density of the treatment effects is shown (normal approximation, unless resampling is used). 
"both" include the "outcome" and "density" plots. If tree.plots = "none", then only the 
tree structure is shown.}

\item{nudge_out}{Nudge tree outcome plot (see ggparty for details)}

\item{width_out}{Width of tree outcome plot (see ggparty for details)}

\item{nudge_dens}{Nudge tree density plot}

\item{width_dens}{Width of density tree outcome plot}

\item{...}{Additional arguments (currently ignored).}
}
\value{
Plot (ggplot2) object
}
\description{
For partykit or rpart based tree models, visualize tree structure and subgroup (node)
specific treatment estimates. Plots (ggparty) can include other node-specific information, 
see below for details.
}
