#' Sub-population information
#' 
#' Sub-population information of samples. This data was published by Zhao et al. (2011) <doi:10.1038/ncomms1467>
#' 
#' @format A character vector.
#' 
#' @source \url{http://www.ricediversity.org/data/} 
#' @examples 
#' data(subpop)
"subpop"


#' Genotype information
#' 
#' A PCA matrix of rice genotype information. This data was published by Zhao et al. (2011) <doi:10.1038/ncomms1467>
#' 
#' @format A numeric matrix (PCA) with 404 rows (sample) and 404 columns (PCs).
#' 
#' @source \url{http://www.ricediversity.org/data/} 
#' @examples 
#' data(geno)
"geno"