% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optTrain.R
\name{optTrain}
\alias{optTrain}
\title{Optimal training set determination}
\usage{
optTrain(
  geno,
  cand,
  n.train,
  subpop = NULL,
  test = NULL,
  method = "rScore",
  min.iter = NULL
)
}
\arguments{
\item{geno}{A numeric matrix of principal components (rows: individuals; columns: PCs).}

\item{cand}{An integer vector of which rows of individuals are candidates of the training set in the geno matrix.}

\item{n.train}{The size of the target training set. This could be determined with the help of the ssdfgp function provided in this package.}

\item{subpop}{A character vector of sub-population's group name. The algorithm will ignore the population structure if it remains NULL.}

\item{test}{An integer vector of which rows of individuals are in the test set in the geno matrix. The algorithm will use an un-target method if it remains NULL.}

\item{method}{Choices are rScore, PEV and CD. rScore will be used by default.}

\item{min.iter}{Minimum iteration of all methods can be appointed. One should always check if the algorithm is converged or not. A minimum iteration will set by considering the candidate and test set size if it remains NULL.}
}
\value{
This function will return 3 information including OPTtrain (a vector of chosen optimal training set), TOPscore (highest scores of before iteration), and ITERscore (criteria scores of each iteration).
}
\description{
This function is designed for determining optimal training set.
}
\examples{
data(geno)
\dontrun{optTrain(geno, cand = 1:404, n.train = 100)}

}
\author{
Jen-Hsiang Ou
}
