% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicfcts_TS_extended.R
\name{charRDTS}
\alias{charRDTS}
\title{Characteristic function of the rapidly decreasing tempered stable (RDTS)
distribution}
\usage{
charRDTS(
  t,
  alpha = NULL,
  delta = NULL,
  lambdap = NULL,
  lambdam = NULL,
  mu = NULL,
  theta = NULL
)
}
\arguments{
\item{t}{A vector of real numbers where the CF is evaluated.}

\item{alpha}{Stability parameter. A real number between 0 and 2.}

\item{delta}{Scale parameter. A real number > 0.}

\item{lambdap, lambdam}{Tempering parameter. A real number > 0.}

\item{mu}{A location parameter, any real number.}

\item{theta}{Parameters stacked as a vector.}
}
\value{
The CF of the the rapidly decreasing tempered stable distribution.
}
\description{
Theoretical characteristic function (CF) of the rapidly decreasing tempered
stable distribution.
}
\details{
The CF of the RDTS distribution is given by (Rachev et
al. (2011)):
\deqn{\varphi_{RDTS}(t;\theta):=
E_{\theta}\left[\mathrm{e}^{\mathrm{i}tX}\right]=
\exp\left(\mathrm{i}t\mu+\delta(G(\mathrm{i}t;\alpha,\lambda_+)
+G(-\mathrm{i}t;\alpha,\lambda_-))\right),}
where
\deqn{G\left(x;\alpha,r,\lambda\right)=
2^{-\frac{\alpha}{2}-1}\lambda^\alpha\Gamma\left(-\frac{\alpha}{2}\right)
\left(M\left(-\frac{\alpha}{2},\frac{1}{2};\frac{x^2}{2\lambda^2}\right)
-1\right)\\}
\deqn{+2^{-\frac{\alpha}{2}-\frac{1}{2}}\lambda^{\alpha-1}x
\Gamma\left(\frac{1-\alpha}{2}\right)
\left(M\left(\frac{1-\alpha}{2},\frac{3}{2};\frac{x^2}{2\lambda^2}\right)
-1\right).}
\code{M} stands for the confluent hypergeometric function.
}
\examples{
x <- seq(-5,5,0.25)
y <- charRDTS(x,0.5,1,1,1,0)

}
\references{
Rachev, Svetlozar T. & Kim, Young Shin & Bianchi, Michele L. & Fabozzi,
Frank J. (2011) 'Financial models with Lévy processes and volatility
clustering' \doi{10.1002/9781118268070}
}
