% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main.R
\name{gen.decision}
\alias{gen.decision}
\title{gen.decision function
This function compares frequency comparison counts of subsamples from two independent samples, and calculates a simulated p-value with a novel bootstrap method proposed in the reference paper.}
\usage{
gen.decision(est.prob, effn.subsam1, effn.subsam2, fn.rep = 10^3,
  alpha = 0.05)
}
\arguments{
\item{est.prob}{a matrix of two rows, with each row represents the the sequential comparison results of subsamples from a sample.}

\item{effn.subsam1}{the subsample sizes from sample 1.}

\item{effn.subsam2}{the subsample sizes from sample 2.}

\item{fn.rep}{the total number of replications.}

\item{alpha}{the size of type I error.}
}
\value{
critical.value the critical value of the test based on the alpha level provided

chi-stat the chisqure type test statistics value from the sample provided.

pvalue the simulated p-value.
}
\description{
gen.decision function
This function compares frequency comparison counts of subsamples from two independent samples, and calculates a simulated p-value with a novel bootstrap method proposed in the reference paper.
}
\details{
The dimensions of est.prob, effn.subsam1 and effn.subsam2 need to match. For example, the first two entries of the first two rows from est.prob are pf comparison results from subsample1 and subsample2 of sample1. Thus the sum of the two entries is the product of the two subsample sizes.
}
\examples{
freq.mat<-rbind(c(20,5,10,15,20,5),c(15,10,15,10,20,5));
n.sam1<-rep(5,4);n.sam2<-rep(5,4); n.rep=1000;
gen.decision(freq.mat,n.sam1,n.sam2,n.rep);
### This command will replicate the first p-value in Table 4 of the reference paper.
freq.mat<-rbind(c(40,10,20,30,40,10),c(30,20,30,20,40,10));
n.sam1<-c(5,10,5,10);n.sam2<-c(10,5,10,5); n.rep=1000;
gen.decision(freq.mat,n.sam1,n.sam2,n.rep)
### This command will replicate the second p-value in Table 4 of the reference paper.
}
\references{
Wang, Y., Stapleton, A. E., & Chen, C. (2018). Two-sample nonparametric stochastic order inference with an application in plant physiology. Journal of Statistical Computation and Simulation, 88(14), 2668-2683.
}
