% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDSM_Gplot.R
\name{Gplot}
\alias{Gplot}
\title{Gplot.}
\usage{
Gplot(
  X,
  f,
  p,
  Anchor.model = NULL,
  xlim = NULL,
  ylim = NULL,
  circlesize = NULL,
  linewidth = NULL,
  fontsize = NULL
)
}
\arguments{
\item{X}{A m*p matrix which contains m different p-dimensional models. All the elements are either 0 or 1.}

\item{f}{A vector with m elements which represent each model's frequency in X.}

\item{p}{The number of variate in the model.}

\item{Anchor.model}{A vector containing p elements with either 1 or 0 value and must be found in X. Default is the model with the highest frequency.}

\item{xlim}{A vector with two elements which determine the range of x-axis in the plot.}

\item{ylim}{A vector with two elements which determine the range of y-axis in the plot.}

\item{circlesize}{customize the size of the circle in the plot, default is 10.}

\item{linewidth}{Customize the width of the line in the plot, default is 1.}

\item{fontsize}{Customize the size of the font in the circles, default is 1.5.}
}
\value{
A list with components
\item{Gplot.info}{The table includes all the information about each group, i.e., the total possible number of models in the group and the actual existing number of model in the group.}
\item{MC.histogram}{The frequency of model complexity.}
\item{HD.histogram}{The frequency of Hamming distance.}
}
\description{
Plotting Gplot.
}
\examples{
data(exampleX)
X=exampleX
data(examplef)
f=examplef
p=8
G_example1 = Gplot(X,f,p)
G_example2 = Gplot(X,f,p,xlim=c(0,7),ylim=c(3,8))
G_example3 = Gplot(X,f,p,xlim=c(0,7),ylim=c(3,8),circlesize=15,linewidth=2,fontsize=3)
}
