% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modis_single.R
\name{radiation_modis}
\alias{radiation_modis}
\title{Energy balance using Landsat-8 images with single agrometeorological data.}
\usage{
radiation_modis(doy, RG, Ta, ET0, a, b)
}
\arguments{
\item{doy}{is the Day of Year (DOY)}

\item{RG}{is the global solar radiation}

\item{Ta}{is the average air temperature}

\item{ET0}{is the reference evapotranspiration}

\item{a}{is one of the regression coefficients of SAFER algorithm}

\item{b}{is one of the regression coefficients of SAFER algorithm}
}
\value{
It returns in raster format (.tif) the Surface Albedo at 24h scale ("Alb_24"), NDVI, Surface Temperature ("LST"), Crop Coefficient ("kc"), Actual Evapotranspiration (evapo), latent heat flux "LE_MJ"), net radiation ("Rn_MJ"), ground heat flux ("G_MJ") and the sensible heat flux ("H_MJ").
}
\description{
Energy balance using Landsat-8 images with single agrometeorological data.
}
\examples{
library(agriwater)

# dependencies of package 'agriwater'
library(terra)

# Using a temporary folder to run example
wd <- tempdir()
initial = getwd()
setwd(wd)

# creating raster which simulate Sentinel-2 reflectances - for using
# real data, please download:
# https://drive.google.com/open?id=14E1wHNLxG7_Dh4I-GqNYakj8YJDgKLzk

xy <- matrix(rnorm(4, mean = 0.05, sd = 0.015),2, 2)
rast <- rast(xy, crs="+proj=longlat +datum=WGS84")
ext(rast) <- c(-40.5,-40.45,-9.5,-9.45)
writeRaster(rast, file.path(wd, "B2.tif"),filetype = "GTiff", overwrite=TRUE)
xy <- matrix(rnorm(4, mean = 0.05, sd = 0.015),2, 2)
rast <- rast(xy, crs="+proj=longlat +datum=WGS84")
ext(rast) <- c(-40.5,-40.45,-9.5,-9.45)
writeRaster(rast, file.path(wd, "B1.tif"),filetype = "GTiff", overwrite=TRUE)

# creating mask of study area
mask <- as.polygons(rast)
writeVector(mask, file.path(getwd(),"mask.shp"), overwrite=TRUE)

# using "agriwater" - it's the same procedure as the used for
# radiation_l8(), radiation_l8t(), radiation_s2(),
# radiation_l8_grid(), radiation_l8t_grid(),
# radiation_s2_grid(), radiation_s2() and radiation_modis_grid()
radiation_modis(doy = 134, RG = 17.6, Ta = 27.9, ET0 = 3.8, a = 1.8, b = -0.008)

#Exiting temporary folder and returning to previous workspace
setwd(initial)
}
