% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mix_opt.R
\name{w_mixEM}
\alias{w_mixEM}
\title{Estimate mixture proportions of a mixture model by EM algorithm (weighted version)}
\usage{
w_mixEM(matrix_lik, prior, pi_init = NULL, weights = NULL, control = list())
}
\arguments{
\item{matrix_lik, }{a n by k matrix with (j,k)th element equal to \eqn{f_k(x_j)}.}

\item{prior, }{a k vector of the parameters of the Dirichlet prior on \eqn{\pi}. Recommended to be rep(1,k)}

\item{pi_init, }{the initial value of \eqn{\pi} to use. If not specified defaults to (1/k,...,1/k).}

\item{weights, }{an n vector of weights}

\item{control}{A list of control parameters for the SQUAREM algorithm, default value is set to be control.default=list(K = 1, method=3, square=TRUE, step.min0=1, step.max0=1, mstep=4, kr=1, objfn.inc=1,tol=1.e-07, maxiter=5000, trace=FALSE).}
}
\value{
A list, including the estimates (pihat), the log likelihood for each interation (B)
and a flag to indicate convergence
}
\description{
Given the individual component likelihoods for a mixture model, and a set of weights, estimates the mixture proportions by an EM algorithm.
}
\details{
Fits a k component mixture model \deqn{f(x|\pi)= \sum_k \pi_k f_k(x)} to independent
and identically distributed data \eqn{x_1,\dots,x_n} with weights \eqn{w_1,\dots,w_n}.
Estimates mixture proportions \eqn{\pi} by maximum likelihood, or by maximum a posteriori (MAP) estimation for a Dirichlet prior on \eqn{\pi} 
(if a prior is specified).  Here the log-likelihood for the weighted data is defined as \eqn{l(\pi) = \sum_j w_j log f(x_j | \pi)}. Uses the SQUAREM package to accelerate convergence of EM. Used by the ash main function; there is no need for a user to call this 
function separately, but it is exported for convenience.
}
