% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandsolve.R
\name{bandsolve}
\alias{bandsolve}
\title{bandsolve}
\usage{
bandsolve(A, b = NULL, inplace = FALSE)
}
\arguments{
\item{A}{Band square matrix in rotated form. The rotated form can be obtained with the function as.rotated: it's the visual rotation by 90 degrees of the matrix, where subdiagonal are discarded.}

\item{b}{right hand side of the equation. Can be either a vector or a matrix. If not supplied, the function return the inverse of A.}

\item{inplace}{Should results overwrite pre-existing data? Default set to false.}
}
\value{
Solution of the linear problem.
}
\description{
Main function to solve efficiently and quickly a symmetric bandlinear system. Theses systems are solved much faster than standards system, dropping from complexity O(n³) to O(0.5*nk²), where k is the number of sub diagonal.
}
\examples{

A = diag(4)
A[2,3] = 2
A[3,2] = 2
R = mat2rot(A)
solve(A)
bandsolve(R)

set.seed(100)

n = 1000
D0 = rep(1.25, n)
D1 = rep(-0.5, n-1)
b = rnorm(n)
}
