% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/challenges.R
\docType{data}
\name{challenges}
\alias{challenges}
\title{Challenges}
\format{
A data frame with 1,136 rows representing individual bakers per episode
and 7 variables:
\describe{
\item{series}{An integer denoting the UK series number (\code{1}-\code{10}).}
\item{episode}{An integer denoting episode number within a series.}
\item{baker}{A character string with a given name or nickname.}
\item{result}{A character string denoting if the baker was \code{IN}, \code{OUT},
\verb{STAR BAKER}, or \code{SICK} for a given episode. For finale episodes, values
are either \code{WINNER} or \code{Runner-up}. If \code{NA}, the baker did not appear in
episode.}
\item{signature}{A character string containing the bake for the signature
challenge for that baker/episode. If \code{NA}, the baker did not appear in
episode.}
\item{technical}{An integer denoting the rank on the technical challenge
for that baker/episode. A value of \code{1} means the baker was the winner of
the technical challenge. If \code{NA}, the baker did not appear in the
episode.}
\item{showstopper}{A character string containing the bake for the
showstopper challenge for that baker/episode. If \code{NA}, the baker did not
appear in episode.}
}
}
\source{
See
\url{https://en.wikipedia.org/wiki/The_Great_British_Bake_Off#Format}
}
\usage{
challenges
}
\description{
Details about the three challenges (\code{"signature"}, \code{"technical"}, and
\code{"showstopper"}) for each baker/episode across all GBBO series. Who was
eliminated? Who won star baker? In the finale, who won and who was runner up?
}
\examples{
if (require('tibble')) {
  challenges
 }
head(challenges)
}
\keyword{datasets}
