% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/episodes.R
\docType{data}
\name{episodes}
\alias{episodes}
\title{Episodes}
\format{
A data frame with 94 rows representing individual episodes per series
and 10 variables:
\describe{
\item{series}{An integer denoting UK series (\code{1}-\code{10}).}
\item{episode}{An integer denoting episode number within a series.}
\item{bakers_appeared}{an integer denoting the number of bakers who
appeared in a given episode.}
\item{bakers_out}{An integer denoting the number of bakers were either
eliminated, left at will, or left due to illness in that episode.}
\item{bakers_remaining}{An integer denoting the number of bakers who
remained at the end of a given episode.}
\item{star_bakers}{An integer denoting the number of bakers crowned Star
Baker in a given episode.}
\item{technical_winners}{An integer denoting the number of bakers who
placed first in the technical challenge.}
\item{sb_name}{A character string with the names of the bakers who won
Star Baker in a given episode, separated by commas.}
\item{winner_name}{A character string with the name of the series winner.
Only present for final episodes within each series.}
\item{eliminated}{A character string with the name of the bakers who left
a given episode, separated by commas.}
}
}
\source{
See
\url{https://en.wikipedia.org/wiki/The_Great_British_Bake_Off#Format}
}
\usage{
episodes
}
\description{
Each episodes' statistics. This dataset is made by collapsing
\code{\link{challenges}} by \code{series} and \code{episode}.
}
\examples{
if (require('tibble')) {
  episodes
 }
head(episodes)
}
\keyword{datasets}
