
#' @title Summary Data from the Vemurafenib Study
#'
#' @description
#' The `vemu` and `vemu_wide` data sets provides response information taken
#' from the ``Vemurafenib in multiple nonmelanoma cancers with BRAF v600
#' mutations'' study where, in total, 18 responders were observed among the
#' 84 patients contributing evaluable outcomes for statistical estimation.
#' Observed response rates varied from $42\%$ and $43\%$ for baskets of NSCLC
#' and ECD or LCH to 0 and $4\%,$ for CRC with vemurafenib mono and
#' combination therapies, respectively. Two responders of seven patients, ATC
#' was associated with a $29\%$ response rate, while one responder of eight
#' patients was observed in the cholangiocarcinoma basket. Contrasting
#' favorable results for preliminary vemurafenib activity among NSCLC and ECD
#' or LCH patients with less favorable results for CRC patients, the authors
#' concluded that nonmelanoma tumor types harboring $BRAF^{V600}$ mutations
#' failed to respond uniformly to BRAF-targeted therapy giving credence to
#' more conventional organ-specific nosology when compared to molecular tumor
#' nosology.
#'
#' Later, in the ``Statistical challenges posed by basket trials: sensitivity
#' analysis of the Vemurafenib study'' it was shown that patient-enrollment
#' types we likely drove the negative results for several targets, rather
#' than Vemurafenib itself.
#' @name vemu
#' @aliases vemu_wide
#' @docType data
#' @rdname vemu
#' @references Hyman DM, Puzanov I, Subbiah V, Faris JE, Chau I, Blay JY,
#' Wolf J, Raje NS, Diamond EL, Hollebecque A, et al. Vemurafenib in multiple
#' nonmelanoma cancers with braf v600 mutations. New England Journal of
#' Medicine 2015; \strong{373}(8):726
NULL
