% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/24_putRatioBackspreadPnL.R
\name{putRatioBackspreadPnL}
\alias{putRatioBackspreadPnL}
\title{Calculates per share Profit and Loss at expiration for Put Ratio Backspread and draws its graph in the Plots tab.}
\usage{
putRatioBackspreadPnL(
  ST,
  X1L,
  X2H,
  PX1L,
  PX2H,
  hl = 0,
  hu = 1.4,
  xlab = "Spot Price ($) at Expiration",
  ylab = " Profit / Loss [PnL] at Expiration ($)",
  main = " Put Ratio Backspread [ PnL ]"
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X1L}{Lower Strike Price or eXercise price.}

\item{X2H}{Higher Strike Price or eXercise price.}

\item{PX1L}{Put Premium paid for the bought Puts at Lower Strike.}

\item{PX2H}{Put Premium received for the sold Put at higher Strike.}

\item{hl}{lower bound value for setting lower-limit of x-axis displaying spot price.}

\item{hu}{upper bound value for setting upper-limit of x-axis displaying spot price.}

\item{xlab}{X-axis label.}

\item{ylab}{Y-axis label.}

\item{main}{Title of the Graph.}
}
\value{
Returns a graph of the strategy.
}
\description{
This strategy consists of a shorting one (or two) put options with a strike price X2H, and a buying two (or three) put options with a lower strike price X1L. The outlook of the trader is strongly bearish. On initiation, this is a net Debit Strategy and results in net cash outflow as premium paid on buying 2 puts (at lower strike) is more than premium received from selling one put (at higher strike) (Kakushadze & Serur, 2018).
}
\details{
According to conceptual details given by Cohen (2015), and a closed-form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute per share Profit and Loss at expiration for Put Ratio Backspread and draw its graph in the Plots tab. EXAMPLE, Buying two HypoERP December 25 Put at $2.15 and buy HypoERP December 30 put at $4.20. The graph gets displayed in Plots tab.
}
\examples{
putRatioBackspreadPnL(25,25,30,2.15,4.20)
}
\references{
Cohen, G. (2015). The Bible of Options Strategies (2nd ed.). Pearson Technology Group. https://bookshelf.vitalsource.com/books/9780133964448\cr
Kakushadze, Z., & Serur, J. A. (2018, August 17). 151 Trading Strategies. Palgrave Macmillan. https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3247865
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
