% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/14_coveredPutInitialValueV0.R
\name{coveredPutInitialValueV0}
\alias{coveredPutInitialValueV0}
\title{Displays graph of the Initial Value as Net Credit (V0Cr) per share or unit of the underlying for Covered Put.}
\usage{
coveredPutInitialValueV0(
  ST,
  X,
  P,
  S0,
  hl = 0,
  hu = 1.5,
  xlab = "Spot Price ($) at Expiration",
  ylab = " Initial Value [ V0] ($)",
  main = "Covered Put / Married Put V0 [Dr/Cr]"
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X}{Strike Price or eXercise price..}

\item{P}{Put Premium.}

\item{S0}{Initial Stock Price.}

\item{hl}{lower bound value for setting lower-limit of x-axis displaying spot price.}

\item{hu}{upper bound value for setting upper-limit of x-axis displaying spot price.}

\item{xlab}{X-axis label.}

\item{ylab}{Y-axis label.}

\item{main}{Title of the Graph.}
}
\value{
Returns a graph of the strategy.
}
\description{
A covered put is the bearish equivalent of a covered call. It is achieved by short-selling the underlying stock and writing an equivalent put against it. By writing a put against a short sale, the trader is now in the position to buy the stock, if exercised, when the market price fell below the put’s strike price. The covered put writer is, in effect, forgoing the opportunity to participate in the decrease in stock price under the strike price in exchange for premium received for selling the put for the same (Kakushadze & Serur, 2018).
}
\details{
According to conceptual details given by Cohen (2015), and a closed-form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to display the Initial Value as Net Credit (V0Cr) per share or unit of the underlying for Covered Put. EXAMPLE, Short HypoGamma stock at $20.00 (inflow) and short HypoGamma December 18 call at $2.00 (inflow).
}
\examples{
coveredPutInitialValueV0(18,18,2,20)
coveredPutInitialValueV0(100,100,4,120,hl=0.9,hu=1.1)
coveredPutInitialValueV0(1000,1000,20,1100,hl=0.995,hu=1.01)
}
\references{
Cohen, G. (2015). The Bible of Options Strategies (2nd ed.). Pearson Technology Group. https://bookshelf.vitalsource.com/books/9780133964448\cr
Kakushadze, Z., & Serur, J. A. (2018, August 17). 151 Trading Strategies. Palgrave Macmillan. https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3247865
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
