% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/22_shortComboExpirationValueVT.R
\name{shortComboExpirationValueVT}
\alias{shortComboExpirationValueVT}
\title{Calculates the Value/Payoff per share at expiration for Short Combo and draws its graph in the Plots tab.}
\usage{
shortComboExpirationValueVT(
  ST,
  X1L,
  X2H,
  PX1L,
  CX2H,
  hl = 0,
  hu = 1.6,
  xlab = "Spot Price ($) at Expiration",
  ylab = " Value / Payoff [VT] at Expiration ($)",
  main = "Short Combo [ VT ]"
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X1L}{higher Strike Price or eXercise price.}

\item{X2H}{lower Strike Price or eXercise price.}

\item{PX1L}{Put Premium paid for the bought Put at Lower Strike.}

\item{CX2H}{Call Premium received for the sold Call at higher Strike .}

\item{hl}{lower bound value for setting lower-limit of x-axis displaying spot price.}

\item{hu}{upper bound value for setting upper-limit of x-axis displaying spot price.}

\item{xlab}{X-axis label.}

\item{ylab}{Y-axis label.}

\item{main}{Title of the Graph.}
}
\value{
Returns a graph of the strategy.
}
\description{
Short Combo is also known as short risk reversal and results from buying a put option with a strike price X1L and selling a call option with a strike price X2H with the same expiration date.  Here, X2H > X1L. Outlook  of the trader (investor) is bearish. This strategy results in capital gain (Kakushadze & Serur, 2018).
}
\details{
According to conceptual details given by Cohen (2015), and a closed-form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute the Value/Payoff per share at expiration for Short Combo and draw its graph in the Plots tab. EXAMPLE, Buy HypoCRM December 8 Put at $1.50 and short HypoCRM December 12 call at $2.00. This is a net credit trade as premium received on shorted call (CX1H) at a higher strike is more than the premium paid on the bought put (P1XL) at a lower strike.
}
\examples{
shortComboExpirationValueVT(10,8,12,1.50,2.00)
}
\references{
Cohen, G. (2015). The Bible of Options Strategies (2nd ed.). Pearson Technology Group. https://bookshelf.vitalsource.com/books/9780133964448\cr
Kakushadze, Z., & Serur, J. A. (2018, August 17). 151 Trading Strategies. Palgrave Macmillan. https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3247865
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
