% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_infected.R
\name{preprocess.data}
\alias{preprocess.data}
\title{Prepare data frame for analysis}
\usage{
preprocess.data(
  data,
  infected_in = c("Wuhan", "Outside"),
  symptom_impute = FALSE
)
}
\arguments{
\item{data}{A data frame}

\item{infected_in}{Either "Wuhan" or "Outside"}

\item{symptom_impute}{Whether to use initial medical visit and confirmation to impute missing symptom onset.}
}
\value{
A data frame
}
\description{
Prepare data frame for analysis
}
\details{
A summary of the procedures:
\enumerate{
  \item Convert all dates to number of days since 1-Dec-2019.
  \item Separates data into those returned from Wuhan and those infected outside of wuhan.
  \item Restrict to cases with a known symptom onset date.
  \item Parse column 'Infected' into two columns: Infected_first and Infected_last.
  \item For all cases, set Infected_first to 1 if it is missing.
  \item For outside cases, set Infected_last to be no later than symptom onset.
  \item For Wuhan-exported cases, set Infected_last to no later than symptom onset and end of Wuhan stay.
}
}
\examples{

data(covid19_data)
head(data <- preprocess.data(covid19_data))

\donttest{ ## This is how the wuhan_exported data frame is created
data <- subset(data, Symptom < Inf)
data <- subset(data, Arrived <= 54)
data$Location <- do.call(rbind, strsplit(as.character(data$Case), "-"))[, 1]
wuhan_exported <- data.frame(Location = data$Location,
                             B = data$Begin_Wuhan,
                             E = data$End_Wuhan,
                             S = data$Symptom)
## devtools::use_data(wuhan_exported)
}

}
\author{
Nianqiao Ju <nju@g.harvard.edu>, Qingyuan Zhao <qyzhao@statslab.cam.ac.uk>
}
