% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/energy_balance.r
\name{energy.use.efficiency}
\alias{energy.use.efficiency}
\title{Energy-Use Efficiency (EUE)}
\usage{
energy.use.efficiency(GPP, alpha = 0.422, Rn)
}
\arguments{
\item{GPP}{Gross primary productivity exchange (umol CO2 m-2 s-1)}

\item{alpha}{Energy taken up/released by photosynthesis/respiration (J umol-1)}

\item{Rn}{Net radiation (W m-2)}
}
\value{
\item{EUE -}{Energy use efficiency (-)}
}
\description{
Fraction of net radiation fixed by primary productivity.
}
\details{
Energy use efficiency is calculated as:

           \deqn{EUE = sum(GPP)/sum(Rn)}
         
         where the sums are calculated for complete cases of GPP and Rn over
         the entire time period.
}
\examples{
energy.use.efficiency(GPP=20,Rn=500)

}
\seealso{
\code{\link{light.use.efficiency}}
}
