% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_inv_eff.R
\name{boot_inv_eff}
\alias{boot_inv_eff}
\title{Bootstrapped pairwise differences in psychometric function of groups.}
\usage{
boot_inv_eff(
  n,
  n_sample,
  df,
  items,
  group,
  eff_sizes = c("SDI2", "UDI2", "WSDI", "WUDI", "dmacs"),
  seed = 2711
)
}
\arguments{
\item{n}{Number of bootstraps}

\item{n_sample}{Number of participants to sample}

\item{df}{Data to resample}

\item{items}{Items to resample for the model as vector of strings}

\item{group}{String variable indicating grouping variable}

\item{eff_sizes}{Effect sizes to be returned}

\item{seed}{Seed for replicability}
}
\value{
Returns a dataframe with the bootstrapped effect sizes based on the invariance_eff function in this package for two country comparisons.
}
\description{
Bootstrapped pairwise differences in psychometric function of groups.
}
\examples{
\donttest{
two_country <- dplyr::filter(example, country \%in\% c("NZ" , "BRA"))
boot_inv_eff(n = 10,
             n_sample = 200, df = two_country, group = "country",
              items = paste0("voice",1:3, "m"))
              }
}
