% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/premium.R
\name{premium}
\alias{premium}
\title{Risk Premium computation}
\usage{
premium(tbase, ce_data, rac, utility)
}
\arguments{
\item{tbase}{Name of the base treatment/project}

\item{ce_data}{\code{data.frame} with CE values previously computed}

\item{rac}{Vector with RAC sequence used in the CE computation}

\item{utility}{The utility function: "ExpNeg" if CE it was computed
using Exponential Negative utility function. "Power" if the utility
function was Power}
}
\value{
Generates three objects: A data.frame with the total
values of the premium risks; a \code{data.frame} with the percentage of
difference with respect the base treatment; and a plot with the
treatments' premium risk.
}
\description{
Risk Premium computation
}
\details{
This function computes the risk premium values, regarding
a project or treatment arbitrarily chosen by the user, using a CEs
dataset (a `certainty` object) already computed.
}
\examples{
## Example using profit dataset
data(profitSWG)

# First, compute the CE values
c1 <- certainty(data = profitSWG,ival = .5,fval = 4,utility = "Power")

ce_values <- c1$CE_values  # CE table
ce_rac <- c1$RAC           # RAC vector

# The Risk premium values respect to Serenade treatment
rp <- premium(tbase = "serenade", ce_data = ce_values,rac = ce_rac, utility = "Power")

rp$PremiumRisk       # absolute values
rp$PremiumRiskPer100 # values in percentage
rp$RP_plot()         # plot
}
