% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ce-mean.R
\name{ce_mean}
\alias{ce_mean}
\title{Calculate a CE weighted mean}
\usage{
ce_mean(ce_data)
}
\arguments{
\item{ce_data}{A data frame containing at least a finlwt21 column,
44 replicate weight columns (wtrep01-44), a cost column, and a survey
indicator column. All but the survey column must be numeric.}
}
\value{
A 1-row dataframe containing the following columns:
\itemize{
\item agg_exp - The estimated aggregate expenditure
\item mean_exp - The estimated mean expenditure
\item se - The estimated standard error of the estimated mean expenditure
\item cv - The coefficient of variation of the estimated mean expenditure
}
}
\description{
Calculate a weighted mean using the method used to produce
official CE estimates.
}
\note{
Estimates produced using PUMD, which is topcoded by the CE and has some
records suppressed to protect respondent confidentiality, will not match the
published estimates released by the CE in most cases. The CE's published
estimates are based on confidential data that are not topcoded nor have
records suppressed. You can learn more at
\href{https://www.bls.gov/cex/pumd_disclosure.htm}{CE Protection of Respondent Confidentiality}
}
\examples{

# Download the HG file keeping the section for expenditures on utilities
\dontrun{
utils_hg <- ce_hg(2017, interview) |>
  ce_uccs("Utilities, fuels, and public services", uccs_only = FALSE)
}

# Download and prepare interview data
\dontrun{
utils_interview <- ce_prepdata(
  2017,
  interview,
  uccs = ce_uccs(utils_hg, "Utilities, fuels, and public services"),
  zp = NULL,
  integrate_data = FALSE,
  hg = utils_hg,
  bls_urbn
)
}

# Calculate the mean expenditure on utilities
\dontrun{ce_mean(utils_interview)}

# Calculate the mean expenditure on utilities by urbanicity
\dontrun{
utils_interview |>
  tidyr::nest(-bls_urbn) |>
  mutate(mean_utils = purrr::map(data, ce_mean)) |>
  select(-data) |>
  unnest(mean_utils)
}

}
\seealso{
\code{\link[=ce_quantiles]{ce_quantiles()}} \code{\link[=ce_prepdata]{ce_prepdata()}}
}
