% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ce-quantiles.R
\name{ce_quantiles}
\alias{ce_quantiles}
\title{Calculate a CE weighted quantiles}
\usage{
ce_quantiles(ce_data, probs = 0.5)
}
\arguments{
\item{ce_data}{A data frame containing at least a finlwt21 column and a cost
column. Both columns must be numeric.}

\item{probs}{A numeric vector of probabilities between 0 and 1 for which to
compute quantiles. Default is 0.5 (median).}
}
\value{
A two-column data frame in which the first column contains the
probabilities for which quantiles were calculated and their corresponding
quantiles in the second column.
}
\description{
Calculate a CE weighted quantiles
}
\examples{
\dontrun{
# Download the HG file keeping the section for expenditures on utilities
utils_hg <- ce_hg(2017, interview) |>
  ce_uccs("Utilities, fuels, and public services", uccs_only = FALSE)

# Download and prepare interview data
utils_interview <- ce_prepdata(
  2017,
  interview,
  uccs = ce_uccs(utils_hg, "Utilities, fuels, and public services"),
  zp = NULL,
  integrate_data = FALSE,
  hg = utils_hg,
  bls_urbn
)

# Calculate the 25\%, 50\%, and 75\% utilities expenditure quantiles
ce_quantiles(utils_interview)

# Calculate the 25\%, 50\%, and 75\% utilities expenditure quantiles by
# urbanicity
utils_interview |>
  tidyr::nest(-bls_urbn) |>
  mutate(quant_utils = purrr::map(data, ce_quantiles, c(0.25, 0.5, 0.75))) |>
  select(-data) |>
  unnest(quant_utils)
}
}
\seealso{
\code{\link[=ce_mean]{ce_mean()}}
}
