% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/divisive_clustering.R
\name{divisive_clustering}
\alias{divisive_clustering}
\title{Divisive Hierarchical Clustering}
\usage{
divisive_clustering(data, details = FALSE, waiting = TRUE, ...)
}
\arguments{
\item{data}{a set of observations, presented as a matrix-like object where
every row is a new observation.}

\item{details}{a Boolean determining whether intermediate logs explaining how
the algorithm works should be printed or not.}

\item{waiting}{a Boolean determining whether the intermediate logs should be
printed in chunks waiting for user input before printing the next or not.}

\item{...}{additional arguments passed to \code{\link[=kmeans]{kmeans()}}.}
}
\value{
An \code{\link[stats:hclust]{stats::hclust()}} object which describes the tree produced by the
clustering process.
}
\description{
Perform a hierarchical Divisive cluster analysis on a set of
observations
}
\details{
This function performs a hierarchical cluster analysis for the
\eqn{n} objects being clustered. The definition of a set of clusters using
this method follows a \eqn{n} step process, which repeats until \eqn{n}
clusters remain:

\enumerate{
\item Initially, each object is assigned to the same cluster. The sum of
squares of the distances between objects and their cluster center is
computed.
\item The cluster with the highest sum of squares is split into two using
the k-means algorithm. This step is repeated until \eqn{n} clusters remain.
}
}
\examples{
### !! This algorithm is very slow, so we'll only test it on some datasets !!

### Helper function
test <- function(db, k) {
  print(cl <- clustlearn::divisive_clustering(db, max_iterations = 5))
  par(mfrow = c(1, 2))
  plot(db, col = cutree(cl, k), asp = 1, pch = 20)
  h <- rev(cl$height)[50]
  clu <- as.hclust(cut(as.dendrogram(cl), h = h)$upper)
  ctr <- unique(cutree(cl, k)[cl$order])
  plot(clu, labels = FALSE, hang = -1, xlab = "Cluster", sub = "", main = "")
  rect.hclust(clu, k = k, border = ctr)
}

### Example 1
# test(clustlearn::db1, 2)

### Example 2
# test(clustlearn::db2, 2)

### Example 3
# test(clustlearn::db3, 3)

### Example 4
# test(clustlearn::db4, 3)

### Example 5
test(clustlearn::db5, 3)

### Example 6
test(clustlearn::db6, 3)

### Example 7 (with explanations, no plots)
  cl <- clustlearn::divisive_clustering(
  clustlearn::db5[1:6, ],
  details = TRUE,
  waiting = FALSE
)

}
\author{
Eduardo Ruiz Sabajanes, \email{eduardo.ruizs@edu.uah.es}
}
