% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configtype.R
\name{is.yaml.file}
\alias{is.yaml.file}
\title{Function to check wheather file is YAML format}
\usage{
is.yaml.file(
  file = Sys.getenv("R_CONFIGFILE_ACTIVE", "config.cfg"),
  yaml.file.debug = FALSE,
  ...
)
}
\arguments{
\item{file}{File name of configuration file to test. Defaults to the value of
the 'R_CONFIGFILE_ACTIVE' environment variable ('config.cfg' if the
variable does not exist and JSON/INI/YAML/TOML format only)}

\item{yaml.file.debug}{If TRUE, it will show error infomation when read YAML config,
default is FALSE}

\item{...}{Arguments for \code{\link{is.json.file}},
\code{\link{readLines}} and \code{\link[yaml]{yaml.load}}}
}
\value{
Logical indicating whether the specified configuration file is YAML format
}
\description{
Function to check wheather file is YAML format
}
\examples{
config.json <- system.file('extdata', 'config.json', package='configr')
config.ini <- system.file('extdata', 'config.ini', package='configr')
config.yaml <- system.file('extdata', 'config.yaml', package='configr')
config.toml <- system.file('extdata', 'config.toml', package='configr')
print(is.yaml.file(config.yaml))
print(is.yaml.file(config.json))
print(is.yaml.file(config.ini))
print(is.yaml.file(config.toml))
}
\seealso{
\code{\link{is.json.file}},
\code{\link{is.ini.file}},
\code{\link{is.toml.file}}
}
