% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{coreHunterData}
\alias{coreHunterData}
\title{Initialize Core Hunter data.}
\usage{
coreHunterData(genotypes, phenotypes, distances)
}
\arguments{
\item{genotypes}{Genetic marker data (\code{chgeno}).}

\item{phenotypes}{Phenotypic trait data (\code{chpheno}).}

\item{distances}{Precomputed distance matrix (\code{chdist}).}
}
\value{
Core Hunter data (\code{chdata}) with elements
\describe{
 \item{\code{geno}}{Genotype data of class \code{chgeno} if included.}
 \item{\code{pheno}}{Phenotype data of class \code{chpheno} if included.}
 \item{\code{dist}}{Distance data of class \code{chdist} if included.}
 \item{\code{size}}{Number of individuals in the dataset.}
 \item{\code{ids}}{Unique item identifiers.}
 \item{\code{names}}{Item names. Names of individuals to which no explicit name
   has been assigned are equal to the unique \code{ids}.}
 \item{\code{java}}{Java version of the data object.}
}

Core Hunter data of class \code{chdata}.
}
\description{
The data may contain genotypes, phenotypes and/or a precomputed distance matrix.
All provided data should describe the same individuals which is verified by comparing
the item ids and names.
}
\examples{
\dontrun{
geno.file <- system.file("extdata", "genotypes.csv", package = "corehunter")
pheno.file <- system.file("extdata", "phenotypes.csv", package = "corehunter")
dist.file <- system.file("extdata", "distances.csv", package = "corehunter")

my.data <- coreHunterData(
  genotypes(file = geno.file, format = "default"),
  phenotypes(file = pheno.file),
  distances(file = dist.file)
)
}

}
\seealso{
\code{\link{genotypes}}, \code{\link{phenotypes}}, \code{\link{distances}}
}
