% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/playfair.R
\name{playfair}
\alias{playfair}
\title{Playfair Cipher}
\usage{
playfair(message, key, encrypt = TRUE)
}
\arguments{
\item{message}{a character vector to be encrypted or decrypted}

\item{key}{a character vector to be used as the encryption key}

\item{encrypt}{(Default: \code{TRUE}) TRUE will encrypt the message, while FALSE will decrypt the message.}
}
\value{
A character vector of either plaintext that has been encrypted or ciphertext that has been decrypted.
}
\description{
This can be used to encrypt or decrypt a Playfair cipher. A Playfair cipher is a polygraphic substitution cipher
that maps digrams of text to other elements of an encryption matrix which is generated by a keyword.
}
\examples{
playfair("SUPERSECRETMESSAGE", "safety", encrypt = TRUE)
playfair("YSQFNTFDQTGRTAAFDT", "safety", encrypt = FALSE)
playfair("$\%^Att&(a09Ck___He86re", "safety", encrypt = TRUE)
playfair("FSSFKPLSQT", "safety", encrypt = FALSE)

}
