% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7-Path.R
\name{path_bezier}
\alias{path_bezier}
\title{Bezier Curve Path}
\usage{
path_bezier(start, end, c1, c2 = NULL, n = 50)
}
\arguments{
\item{start}{starting \code{(row, col)} coordinate}

\item{end}{ending \code{(row, col)} coordinate}

\item{c1}{coordinate of first control point}

\item{c2}{coordinate of second control point}

\item{n}{number of points along curve to calculate}
}
\value{
Nx2 matrix of \code{(row, column)} coordinates
}
\description{
Calculate the path of a Bezier Curve with up to two control points in a grid.
}
\examples{
path_bezier(start=c(10,1), end=c(10,10), c1=c(1, 3))

}
\seealso{
Other path-fitting functions: 
\code{\link{path_arc}()},
\code{\link{path_circle}()},
\code{\link{path_ellipse}()},
\code{\link{path_fill}()},
\code{\link{path_fn}()},
\code{\link{path_intersection}()},
\code{\link{path_lerp}()},
\code{\link{path_ray}()},
\code{\link{path_rect}()},
\code{\link{path_shape}()}
}
\concept{path-fitting functions}
