% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{dafforne_accounts}
\alias{dafforne_accounts}
\title{Accounts from the practice journal and ledger of Richard Dafforne}
\format{
A data frame with 46 rows and 5 variables.
}
\source{
Richard Dafforne, \emph{The Merchant's Mirrour, Or Directions for the}
\emph{Perfect Ordering and Keeping of His Accounts}, Third Edition, (London,
1660)
}
\usage{
dafforne_accounts
}
\description{
A data set of the accounts from the first practice journal and ledger in
Richard Dafforne's accounting manual from 1660 called \emph{The Merchant's}
\emph{Mirrour}. By 1660 \emph{The Merchant's Mirrour} was in its third edition, and
its contents had been printed in the well-known merchant manual of Gerard
Malynes, \emph{Consuetudo Vel Lex Mercatoira} since the 1636 edition, making it
one of the most popular bookkeeping manuals in 17th-century England. The
data set is meant to be used in conjunction with \code{dafforne_transactions}.
It contains information on the accounts found in the practice journal and
ledger that Dafforne used to teach double-entry bookkeeping practices.
}
\details{
The data set does not include the Balance account that Dafforne uses to
close the books. The transactions from this account can be recreated using
the lsd account functions in \code{debkeepr}.
}
\section{Variables}{

\itemize{
\item \code{id}: Numeric id for each account. The ids correspond to the ids in the
\code{credit} and \code{debit} variables in \code{dafforne_transactions}.
\item \code{account}: Name of the account.
\item \code{ledger}: Page on which the account appears in the ledger.
\item \code{investor}: The investor or the person's whose capital is involved in
the account. Accounts that only deal with the bookkeeper's capital are
listed as "ego".
\item \code{description}: Short description of each account.
}
}

\keyword{datasets}
